﻿using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;
using Microsoft.Xna.Framework.Net;
using Microsoft.Xna.Framework.Storage;

namespace Chapitre_11
{
    public class Chapitre11 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        Map map;
        Tile herosA;
        Rectangle cameraA;

        public Chapitre11()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";
            ServiceHelper.Game = this;
            Components.Add(new KeyboardService(this));
            graphics.PreferredBackBufferWidth = 160;
            graphics.PreferredBackBufferHeight = 160;
        }

        protected override void Initialize()
        {
            map = new Map(new byte[,] { {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}
                                      , {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}
                                      , {0, 1, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 1, 0, 0, 0, 1, 0}
                                      , {0, 1, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 0, 0, 0, 1, 0}
                                      , {0, 1, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 1, 0, 0, 0, 1, 0}
                                      , {0, 1, 3, 0, 0, 0, 0, 0, 0, 0, 2, 2, 1, 1, 1, 0, 1, 0}
                                      , {0, 1, 3, 3, 0, 0, 0, 0, 0, 0, 0, 2, 2, 0, 0, 0, 1, 0}
                                      , {0, 1, 3, 3, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 0, 0, 1, 0}
                                      , {0, 1, 3, 0, 0, 0, 3, 3, 0, 0, 0, 0, 2, 2, 0, 0, 1, 0}
                                      , {0, 1, 3, 0, 3, 3, 3, 3, 3, 0, 0, 0, 2, 2, 0, 0, 1, 0}
                                      , {0, 1, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 2, 2, 2, 0, 1, 0}
                                      , {0, 1, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 2, 2, 0, 1, 0}
                                      , {0, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0}
                                      , {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}});

            cameraA = new Rectangle(0, 0, 5, 5);
            herosA = new Tile(2, 2, 4);
            herosA.Position = new Vector2(64, 64);

            base.Initialize();
        }

        protected override void LoadContent()
        {
            spriteBatch = new SpriteBatch(GraphicsDevice);

            foreach (Tile tile in map.TileList)
            {
                tile.LoadContent(Content, "tile");
            }
            herosA.LoadContent(Content, "tile");
        }

        protected override void Update(GameTime gameTime)
        {
            if (ServiceHelper.Get<IKeyboardService>().KeyHasBeenPressed(Keys.Up))
            {
                if (map.TileList[herosA.Y - 1, herosA.X].Type >= 0)
                {
                    cameraA.Y -= 1;
                    herosA.Y -= 1;
                }
            }
            if (ServiceHelper.Get<IKeyboardService>().KeyHasBeenPressed(Keys.Right))
            {
                if (map.TileList[herosA.Y, herosA.X + 1].Type >= 0)
                {
                    cameraA.X += 1;
                    herosA.X += 1;
                }
            }
            if (ServiceHelper.Get<IKeyboardService>().KeyHasBeenPressed(Keys.Down))
            {
                if (map.TileList[herosA.Y + 1, herosA.X].Type >= 0)
                {
                    cameraA.Y += 1;
                    herosA.Y += 1;
                }
            }
            if (ServiceHelper.Get<IKeyboardService>().KeyHasBeenPressed(Keys.Left))
            {
                if (map.TileList[herosA.Y, herosA.X - 1].Type >= 0)
                {
                    cameraA.X -= 1;
                    herosA.X -= 1;
                }
            }

            base.Update(gameTime);
        }

        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.Black);

            spriteBatch.Begin();
            map.Draw(spriteBatch, cameraA);
            herosA.Draw(spriteBatch);
            spriteBatch.End();

            base.Draw(gameTime);
        }
    }
}
